/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
using System.Collections;
using System.Text;

namespace Inet.Viewer.Data
{


    /// <summary>
    /// This class represents a multivalue prompt value.
    /// @author LarsF
    /// </summary>
    internal class MultiPromptValue : PromptValue
    {

        /// <summary>
        /// vector of single or range prompt values </summary>
        private ArrayList values = new ArrayList();



        /// <summary>
        /// Creates a MultiPromptValue,  represents a multivalue prompt value. </summary>
        /// <param name="defaultValue"> The default value. </param>
        /// <param name="description"> the description </param>
        /// <param name="type"> the value type. </param>
        public MultiPromptValue(ArrayList defaultValue, string description, int type)
            : base(description, type)
        {
            values = defaultValue;
        }

        /// <summary>
        /// Creates a MultiPromptValue,  represents a multivalue prompt value. </summary>
        /// <param name="type"> the value type. </param>
        public MultiPromptValue(int type)
            : base(type)
        {
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public override string ToString()
        {
            string resultString = string.Empty;
            if (!this.OnlyDescription)
            {

                resultString = ValueString;
            }
            else
            {
                if (resultString.Length > 0)
                {
                    resultString += " - ";
                }
                resultString = this.Description;
            }
            return resultString;
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        internal override string ValueString
        {
            get
            {
                StringBuilder p = new StringBuilder("[");
                for (int i = 0; i < values.Count; i++)
                {
                    if (i > 0) p.Append(",");
                    object obj = values[i];
                    if (obj != null)
                    {
                        p.Append(((PromptValue)obj).StringRepresentation);
                    }
                    else
                    {
                        p.Append("null");
                    }
                }
                p.Append("]");
                return p.ToString();
            }
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public override object Value
        {
            get
            {
                return Values;
            }
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        internal override void InitValue()
        {
            // nothing to do - just an empty vector
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public override string StringRepresentation
        {
            get
            {
                IEnumerator it = Values.GetEnumerator();
                StringBuilder p = new StringBuilder("[");
                while (it.MoveNext())
                {

                    PromptValue pVal = (PromptValue)it.Current;
                    string val;
                    if (pVal != null && (val = pVal.StringRepresentation).Length != 0)
                    {
                        p.Append(val);
                    }
                    else
                    {
                        p.Append("null");
                    }
                    p.Append(",");
                }
                if (p.Length == 1)
                {
                    return "[]";
                }
                p[p.Length - 1] = ']';
                return p.ToString();
            }
        }

        /// <summary>
        /// return a vector of values. </summary>
        /// <returns> a vector of values. </returns>

        internal virtual ArrayList Values
        {
            get
            {
                return values;
            }
        }

    }

}